libname iri 'C:\Users\John\Dropbox\Papers Data\IRI data';
libname perm 'C:\Users\John\Dropbox\My Solo Projects\Inactive\Field Paper\Exp';

** Import CPI;
PROC IMPORT OUT= WORK.cpi 
            DATAFILE= "C:\Users\John\Dropbox\Papers Data\IRI data\cpi.dta" 
            DBMS=STATA REPLACE;
RUN;

** Merge CPI into UPC data and calculate total revenue;
* carbbev;
proc sort data = work.carbbev_panel;
	by monthid;
data work.carbbev_cpi;
	merge work.carbbev_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.carbbev_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.carbbev_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.carbbev_upc_rev;
	by descending revenue;
run;
data work.carbbev_upc_rev2;
	set work.carbbev_upc_rev;

	category = "carbbev";
	rank + 1;
run;
data work.carbbev_upc_select;
	set work.carbbev_upc_rev2;

	if rank > 30 then delete;
run;
proc sort data = work.carbbev_upc_select;
	by colupc;
proc sort data = work.carbbev_panel;
	by colupc;
data work.carbbev_select;
	merge work.carbbev_panel (in=in1) work.carbbev_upc_select (in=in2);
	by colupc;
	if in1 and in2;
run;
proc datasets library = work;
	delete carbbev_panel;
* margbutr;
proc sort data = work.margbutr_panel;
	by monthid;
data work.margbutr_cpi;
	merge work.margbutr_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.margbutr_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.margbutr_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.margbutr_upc_rev;
	by descending revenue;
run;
data work.margbutr_upc_rev2;
	set work.margbutr_upc_rev;

	category = "margbutr";
	rank + 1;
run;
data work.margbutr_upc_select;
	set work.margbutr_upc_rev2;

	if rank > 30 then delete;
run;
proc sort data = work.margbutr_upc_select;
	by colupc;
proc sort data = work.margbutr_panel;
	by colupc;
data work.margbutr_select;
	merge work.margbutr_panel (in=in1) work.margbutr_upc_select (in=in2);
	by colupc;
	if in1 and in2;
run;
proc datasets library = work;
	delete coffee;
* coffee;
proc sort data = work.coffee_panel;
	by monthid;
data work.coffee_cpi;
	merge work.coffee_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.coffee_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.coffee_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.coffee_upc_rev;
	by descending revenue;
run;
data work.coffee_upc_rev2;
	set work.coffee_upc_rev;

	category = "coffee";
	rank + 1;
run;
proc datasets library = work;
	delete coffee_panel;
* coldcer;
proc sort data = work.coldcer_panel;
	by monthid;
data work.coldcer_cpi;
	merge work.coldcer_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.coldcer_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.coldcer_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.coldcer_upc_rev;
	by descending revenue;
run;
data work.coldcer_upc_rev2;
	set work.coldcer_upc_rev;

	category = "coldcer";
	rank + 1;
run;
proc datasets library = work;
	delete coldcer_panel;
* fzdinent;
proc sort data = work.fzdinent_panel;
	by monthid;
data work.fzdinent_cpi;
	merge work.fzdinent_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.fzdinent_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.fzdinent_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.fzdinent_upc_rev;
	by descending revenue;
run;
data work.fzdinent_upc_rev2;
	set work.fzdinent_upc_rev;

	category = "fzdinent";
	rank + 1;
run;
proc datasets library = work;
	delete fzdinent_panel;
* fzpizza;
proc sort data = work.fzpizza_panel;
	by monthid;
data work.fzpizza_cpi;
	merge work.fzpizza_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.fzpizza_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.fzpizza_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.fzpizza_upc_rev;
	by descending revenue;
run;
data work.fzpizza_upc_rev2;
	set work.fzpizza_upc_rev;

	category = "fzpizza";
	rank + 1;
run;
proc datasets library = work;
	delete fzpizza_panel;
* hotdog;
proc sort data = work.hotdog_panel;
	by monthid;
data work.hotdog_cpi;
	merge work.hotdog_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.hotdog_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.hotdog_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.hotdog_upc_rev;
	by descending revenue;
run;
data work.hotdog_upc_rev2;
	set work.hotdog_upc_rev;

	category = "hotdog";
	rank + 1;
run;
proc datasets library = work;
	delete hotdog_panel;
* mayo;
proc sort data = work.mayo_panel;
	by monthid;
data work.mayo_cpi;
	merge work.mayo_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.mayo_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.mayo_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.mayo_upc_rev;
	by descending revenue;
run;
data work.mayo_upc_rev2;
	set work.mayo_upc_rev;

	category = "mayo";
	rank + 1;
run;
proc datasets library = work;
	delete mayo_panel;
* mustketc;
proc sort data = work.mustketc_panel;
	by monthid;
data work.mustketc_cpi;
	merge work.mustketc_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.mustketc_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.mustketc_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.mustketc_upc_rev;
	by descending revenue;
run;
data work.mustketc_upc_rev2;
	set work.mustketc_upc_rev;

	category = "mustketc";
	rank + 1;
run;
proc datasets library = work;
	delete mustketc_panel;
* peanbutr;
proc sort data = work.peanbutr_panel;
	by monthid;
data work.peanbutr_cpi;
	merge work.peanbutr_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.peanbutr_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.peanbutr_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.peanbutr_upc_rev;
	by descending revenue;
run;
data work.peanbutr_upc_rev2;
	set work.peanbutr_upc_rev;

	category = "peanbutr";
	rank + 1;
run;
data work.peanbutr_upc_select;
	set work.peanbutr_upc_rev2;

	if rank > 50 then delete;
run;
proc sort data = work.peanbutr_upc_select;
	by colupc;
proc sort data = work.peanbutr_panel;
	by colupc;
data work.peanbutr_select;
	merge work.peanbutr_panel (in=in1) work.peanbutr_upc_select (in=in2);
	by colupc;
	if in1 and in2;
run;
proc datasets library = work;
	delete peanbutr_panel;
* saltsnck;
proc sort data = work.saltsnck_panel;
	by monthid;
data work.saltsnck_cpi;
	merge work.saltsnck_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.saltsnck_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.saltsnck_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.saltsnck_upc_rev;
	by descending revenue;
run;
data work.saltsnck_upc_rev2;
	set work.saltsnck_upc_rev;

	category = "saltsnck";
	rank + 1;
run;
data work.saltsnck_upc_select;
	set work.saltsnck_upc_rev2;

	if rank > 30 then delete;
run;
proc sort data = work.saltsnck_upc_select;
	by colupc;
proc sort data = work.saltsnck_panel;
	by colupc;
data work.saltsnck_select;
	merge work.saltsnck_panel (in=in1) work.saltsnck_upc_select (in=in2);
	by colupc;
	if in1 and in2;
run;
proc datasets library = work;
	delete saltsnck_panel;
* soup;
proc sort data = work.soup_panel;
	by monthid;
data work.soup_cpi;
	merge work.soup_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.soup_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.soup_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.soup_upc_rev;
	by descending revenue;
run;
data work.soup_upc_rev2;
	set work.soup_upc_rev;

	category = "soup";
	rank + 1;
run;
proc datasets library = work;
	delete soup_panel;
* spagsauc;
proc sort data = work.spagsauc_panel;
	by monthid;
data work.spagsauc_cpi;
	merge work.spagsauc_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.spagsauc_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.spagsauc_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.spagsauc_upc_rev;
	by descending revenue;
run;
data work.spagsauc_upc_rev2;
	set work.spagsauc_upc_rev;

	category = "spagsauc";
	rank + 1;
run;
proc datasets library = work;
	delete spagsauc_panel;
* sugarsub;
proc sort data = work.sugarsub_panel;
	by monthid;
data work.sugarsub_cpi;
	merge work.sugarsub_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.sugarsub_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.sugarsub_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.sugarsub_upc_rev;
	by descending revenue;
run;
data work.sugarsub_upc_rev2;
	set work.sugarsub_upc_rev;

	category = "sugarsub";
	rank + 1;
run;
proc datasets library = work;
	delete sugarsub_panel;
* yogurt;
proc sort data = work.yogurt_panel;
	by monthid;
data work.yogurt_cpi;
	merge work.yogurt_panel (in=in1) work.cpi (in=in2);
	by monthid;

	weekid = week - 1113;

	realppvol = (dollars / (vol_eq * units)) / cpi * 100;
run;
proc sql;
create table work.yogurt_upc_rev as
select colupc, sum(realppvol * (vol_eq * units)) as revenue
from work.yogurt_cpi
group by colupc
order by colupc;
quit;
run;
proc sort data = work.yogurt_upc_rev;
	by descending revenue;
run;
data work.yogurt_upc_rev2;
	set work.yogurt_upc_rev;

	category = "yogurt";
	rank + 1;
run;
proc datasets library = work;
	delete yogurt_panel;
run;

** Merge all food categories;
data work.revenue (drop = rank);
	set work.carbbev_upc_rev2 work.coffee_upc_rev2 work.coldcer_upc_rev2 work.fzdinent_upc_rev2 work.fzpizza_upc_rev2 work.hotdog_upc_rev2 work.margbutr_upc_rev2 work.mayo_upc_rev2 work.mustketc_upc_rev2 work.peanbutr_upc_rev2 work.saltsnck_upc_rev2 work.soup_upc_rev2 work.spagsauc_upc_rev2 work.sugarsub_upc_rev2 work.yogurt_upc_rev2;
proc sort data = work.revenue;
	by descending revenue;
run;
data work.rev_rank;
	set work.revenue;

	rank + 1;
run;
